<?php
require __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../includes/db.php';
use Dompdf\Dompdf;

$stmt = $pdo->query('SELECT c.*, p.name as package_name FROM customers c LEFT JOIN packages p ON c.package_id=p.id');
$rows = $stmt->fetchAll();

$html = '<h1>Daftar Pelanggan</h1><table border="1" cellpadding="6"><tr><th>ID</th><th>Nama</th><th>Paket</th><th>Status</th></tr>';
foreach ($rows as $r) {
  $html .= '<tr><td>' . $r['id'] . '</td><td>' . htmlspecialchars($r['full_name']) . '</td><td>' . htmlspecialchars($r['package_name']) . '</td><td>' . $r['status'] . '</td></tr>';
}
$html .= '</table>';

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper('A4','landscape');
$dompdf->render();
$dompdf->stream('pelanggan.pdf', ['Attachment' => 0]);
exit;
